using System;
using System.Collections.Generic;
using Server.Items;
using Server.Targeting;
using Server.ContextMenus;
using Server.Gumps;
using Server.Misc;
using Server.Network;
using Server.Spells;

namespace Server.Mobiles
{
	//[CorpseName( "Norivar's Corpse" )]
	public class Norivar : Mobile
	{
                public virtual bool IsInvulnerable{ get{ return true; } }
		[Constructable]
		public Norivar()
		{
			Name = "Norivar";
            Title = "the Smite Cleric";
			Body = 0x190;
			CantWalk = true;
			Hue = Utility.RandomSkinHue();
			AddItem( new Server.Items.Boots( GetBootsHue() ) );
			AddItem( new Server.Items.BoneCrusher() );
			AddItem( new Server.Items.RelicOfTheChurch() );
			AddItem( new Server.Items.HolyKnightsBreastplate() );
			AddItem( new Server.Items.Kilt() );
			AddItem( new Server.Items.BodySash() );
                        		int hairHue = 1153;

			switch ( Utility.Random( 1 ) )
			{
				case 0: AddItem( new LongHair( hairHue ) ); break;
			} 
			
			Blessed = true;
			
			}

			public virtual int GetBootsHue()
			{
			return 1623;
		}

		public Norivar( Serial serial ) : base( serial )
		{
		}

		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list ) 
	        { 
	                base.GetContextMenuEntries( from, list ); 
        	        list.Add( new NorivarEntry( from, this ) ); 
	        } 

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}

		public class NorivarEntry : ContextMenuEntry
		{
			private Mobile m_Mobile;
			private Mobile m_Giver;
			
			public NorivarEntry( Mobile from, Mobile giver ) : base( 6146, 3 )
			{
				m_Mobile = from;
				m_Giver = giver;
			}

			public override void OnClick()
			{
				

                          if( !( m_Mobile is PlayerMobile ) )
					return;
				
				PlayerMobile mobile = (PlayerMobile) m_Mobile;

				{
					if ( ! mobile.HasGump( typeof( NorivarGump ) ) )
					{
						mobile.SendGump( new NorivarGump( mobile ));
						
					} 
				}
			}
		}

		public override bool OnDragDrop( Mobile from, Item dropped )
		{          		
			PlayerMobile mobile = from as PlayerMobile;

			if ( mobile != null)
			{
				if( dropped is GraniteStone )
         		{
         			if(dropped.Amount!=35)
         			{
					this.PrivateOverheadMessage( MessageType.Regular, 1153, false, "To nen mnostv o kter jsem t dal!", mobile.NetState );
         				return false;
         			}

					dropped.Delete();
					
					Item reward = new RelicOfTheChurch();
					reward.BlessedFor = from;
					
					mobile.AddToBackpack( reward );
					mobile.SendGump( new NorivarFinishGump());
				
					return true;
         		}
				else if ( dropped is GraniteStone)
				{
				this.PrivateOverheadMessage( MessageType.Regular, 1153, 1054071, mobile.NetState );
         			return false;
				}
         		else
         		{
					this.PrivateOverheadMessage( MessageType.Regular, 1153, false, "K emu bych mohl tohle potebovat?", mobile.NetState );
     			}
			}
			return false;
		}
	}
}
